#ifndef DDIRECTORIOSPORDEFECTO_H
    #define DDIRECTORIOSPORDEFECTO_H
    
    #include "DString.h"

    #if _MSC_VER > 1400 // Visual Studio 8 o superior
	    #include <KnownFolders.h>
	    typedef HRESULT (WINAPI* TpSHGetKnownFolderPath)(const GUID& rfid, DWORD dwFlags, HANDLE hToken, PWSTR *path);
    #else
	    #if defined UNICODE
		    typedef HRESULT (WINAPI* TpSHGetFolderPath)(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPWSTR pszPath);
	    #else
		    typedef HRESULT (WINAPI* TpSHGetFolderPath)(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPSTR pszPath);
	    #endif
    #endif

    namespace DWL {
        class DSistema;

        class DDirectoriosPorDefecto : public DObjeto {
          public:
									    //! Constructor.
									    /*! Constructor.
											    \fn			DDirectoriosPorDefecto(void);
											    \return		No devuelve nada.
									    */
                                        DDirectoriosPorDefecto(void);
        
									    //! Destructor.
									    /*! Destructor.
											    \fn			~DDirectoriosPorDefecto(void);
											    \return		No devuelve nada.
									    */
								       ~DDirectoriosPorDefecto(void);


									    //! Funcin que retorna el directorio AppData para todos los usuarios del sistema.
									    /*! Esta funcin devuelve el directorio AppData para todos los usuarios del sistema en la clase DWLString proporcionada.
											    \fn			BOOL AppData(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Application Data",
														    si queremos obtener la ruta para el usuario actual debemos usar la funcin AppData_UsuarioActual.
									    */
		    BOOL					    AppData(DString &StrOut);

									    //! Funcin que retorna el directorio AppData del usuario actual.
									    /*! Esta funcin devuelve el directorio AppData comn del usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL AppData_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Application Data",
														    si queremos obtener la ruta para todos los usuarios debemos usar la funcin AppData.
									    */
		    BOOL					    AppData_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como escritorio comn.
									    /*! Esta funcin devuelve el directorio usado como escritorio comn en la clase DWLString proporcionada.
											    \fn			BOOL Escritorio(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Desktop",
														    si queremos obtener la ruta para el usuario actual debemos usar la funcin Escritorio_UsuarioActual.
									    */
		    BOOL					    Escritorio(DString &StrOut);

									    //! Funcin que retorna el directorio usado como escritorio del usuario actual.
									    /*! Esta funcin devuelve el directorio usado como escritorio del usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL Escritorio_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Desktop",
														    si queremos obtener la ruta para todos los usuarios debemos usar la funcin Escritorio.
									    */
		    BOOL					    Escritorio_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Men inicio -> Programas.
									    /*! Esta funcin devuelve el directorio usado como Men inicio -> Programas en la clase DWLString proporcionada.
											    \fn			BOOL MenuInicio_Programas(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Programs".
									    */
		    BOOL					    MenuInicio_Programas(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Men inicio -> Programas del usuario actual.
									    /*! Esta funcin devuelve el directorio usado como Men inicio -> Programas del usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL MenuInicio_Programas_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Programs".
									    */
		    BOOL					    MenuInicio_Programas_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Documentos.
									    /*! Esta funcin devuelve el directorio usado como Mis Documentos en la clase DWLString proporcionada.
											    \fn			BOOL MisDocumentos(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Documents".
									    */
		    BOOL					    MisDocumentos(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Documentos para el usuario actual.
									    /*! Esta funcin devuelve el directorio usado como Mis Documentos para el usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL MisDocumentos_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Documents".
									    */
		    BOOL	    				MisDocumentos_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Imagenes.
									    /*! Esta funcin devuelve el directorio usado como Mis Imagenes en la clase DWLString proporcionada.
											    \fn			BOOL MisImagenes(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Documents\My Pictures".
									    */
		    BOOL					    MisImagenes(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Imagenes para el usuario actual.
									    /*! Esta funcin devuelve el directorio usado como Mis Imagenes para el usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL MisImagenes_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Documents\My Pictures".
									    */
		    BOOL					    MisImagenes_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mi Msica.
									    /*! Esta funcin devuelve el directorio usado como Mi Msica en la clase DWLString proporcionada.
											    \fn			BOOL MiMusica(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Documents\My Music".
									    */
		    BOOL					    MiMusica(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mi Msica para el usuario actual.
									    /*! Esta funcin devuelve el directorio usado como Mi Msica para el usuario actual en la clase DWLString proporcionada.
											    \fn			BOOL MiMusica_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Documents\My Music".
									    */
		     BOOL					    MiMusica_UsuarioActual(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Videos.
									    /*! Esta funcin devuelve el directorio usado como Mis Videos en la clase DWLString proporcionada.
											    \fn			BOOL MisVideos(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\All Users\Documents\My Videos".
									    */
		     BOOL					    MisVideos(DString &StrOut);

									    //! Funcin que retorna el directorio usado como Mis Videos para el usuario actual.
									    /*! Esta funcin devuelve el directorio usado como Mi Msica para el usuario actual en la clase DWLString proporcionada.
											    \fn			const BOOL	MisVideos_UsuarioActual(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Documents and Settings\USUARIO ACTUAL\Documents\My Videos".
									    */
		     BOOL					    MisVideos_UsuarioActual(DString &StrOut);


									    //! Funcin que retorna el directorio que contiene Windows.
									    /*! Esta funcin devuelve el directorio usado directorio  raz de windows en la clase DWLString proporcionada.
											    \fn			BOOL Windows(DString &StrOut);
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE si la operacin se completo con exito, FALSE en caso contrario.
											    \remarks    Esta funcin devuelve una ruta tipo : "C:\Windows".
									    */
              BOOL					    Windows(DString &StrOut);

            protected: /////////////////// Miembros protegidos
									    //! Funcin que inicia esta clase.
									    /*! Esta funcin inicia la clase de forma que carga la libreria Shell32 y la funcion SHGetKnownFolderPath.
											    \fn			void _Iniciar(void);
											    \return		No devuelve nada.
											    \remarks    Funcin de uso interno para la DWL.
									    */
	        void	                   _Iniciar(OSVERSIONINFOEX VersionWindows);

            //////////////////////////// WINDOWS XP O INFERIOR
									    //! Funcin que llamara a SHGetFolderPath si es posible.
									    /*! Esta funcin llamara a SHGetFolderPath si es posible.
											    \fn			BOOL _ObtenerDirectorioV5(int CSLID, DString &StrOut);
                                                \param[in]  CSLID  : ID en formato CSLID del directorio a obtener.
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE en caso de exito, FALSE en caso de error.
											    \remarks    Funcin de uso interno para la DWL.
									    */
              BOOL				       _ObtenerDirectorioV5(int CSLID, DString &StrOut);

									    //! Modulo shell32.
		      HMODULE	               _Shell32;
            //////////////////////////////

                                        //! Version mayor de windows
            unsigned long              _VersionMayor;

    #if _MSC_VER > 1400 // Visual Studio 8 o superior
            ////////////////////////////// WINDOWS VISTA O SUPERIOR
									    //! Funcin que llamara a SHGetKnownFolderPath si es posible.
									    /*! Esta funcin llamara a SHGetKnownFolderPath si es posible.
											    \fn			BOOL _ObtenerDirectorioV5(int CSLID, DString &StrOut);
                                                \param[in]  rfid   : ID en formato GUID del directorio a obtener.
											    \param[out] StrOut : Clase DWLString en la que se guardara la ruta del directorio.
											    \return		Devuelve TRUE en caso de exito, FALSE en caso de error.
											    \remarks    Funcin de uso interno para la DWL.
									    */
            BOOL				       _ObtenerDirectorioV6(const GUID& rfid, DString &StrOut);

									    //! Funcin SHGetKnownFolderPath (Funciona a partir de Windows 6.x y no se puede usar bajo VC6 y DevC++).
		    TpSHGetKnownFolderPath	   _SHGetKnownFolderPath;
            //////////////////////////////
    #else
                                        //! Funcin SHGetFolderPath
		    TpSHGetFolderPath		   _SHGetFolderPath;
    #endif
            friend class DSistema;
        };
    };

#endif